/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import net.minecraft.class_8705;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.McHelper;
import qouteall.q_misc_util.dimension.DimIntIdMap;
import qouteall.q_misc_util.dimension.DimensionIntId;

public class MiscNetworking {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientPlayNetworking.registerGlobalReceiver(DimIdSyncPacket.TYPE, (p, c) -> p.handle());
    }

    public static void init() {
        PayloadTypeRegistry.playS2C().register(DimIdSyncPacket.TYPE, DimIdSyncPacket.CODEC);
    }

    public record DimIdSyncPacket(class_2487 dimIntIdTag, class_2487 dimTypeTag) implements class_8710
    {
        public static final class_8710.class_9154<DimIdSyncPacket> TYPE = new class_8710.class_9154(McHelper.newResourceLocation("imm_ptl:dim_int_id_sync"));
        public static final class_9139<class_2540, DimIdSyncPacket> CODEC = class_9139.method_56437((b, p) -> p.write((class_2540)b), DimIdSyncPacket::read);

        public static DimIdSyncPacket createFromServer(MinecraftServer server) {
            DimIntIdMap rec = DimensionIntId.getServerMap(server);
            class_2487 dimIntIdTag = rec.toTag(dim -> true);
            class_5455.class_6890 registryManager = server.method_30611();
            class_2378 dimensionTypes = registryManager.method_30530(class_7924.field_41241);
            class_2487 dimIdToDimTypeIdTag = new class_2487();
            for (class_3218 world : server.method_3738()) {
                class_5321 dimId = world.method_27983();
                class_2874 dimType = world.method_8597();
                class_2960 dimTypeId = dimensionTypes.method_10221((Object)dimType);
                if (dimTypeId == null) {
                    LOGGER.error("Cannot find dimension type for {}", (Object)dimId.method_29177());
                    LOGGER.error("Registered dimension types {}", (Object)dimensionTypes.method_10235());
                    dimTypeId = class_7134.field_37666.method_29177();
                }
                dimIdToDimTypeIdTag.method_10582(dimId.method_29177().toString(), dimTypeId.toString());
            }
            return new DimIdSyncPacket(dimIntIdTag, dimIdToDimTypeIdTag);
        }

        public static class_2596<class_8705> createPacket(MinecraftServer server) {
            return ServerPlayNetworking.createS2CPacket((class_8710)DimIdSyncPacket.createFromServer(server));
        }

        public void write(class_2540 buf) {
            buf.method_10794((class_2520)this.dimIntIdTag);
            buf.method_10794((class_2520)this.dimTypeTag);
        }

        public static DimIdSyncPacket read(class_2540 buf) {
            class_2487 idMapTag = buf.method_10798();
            class_2487 typeTag = buf.method_10798();
            return new DimIdSyncPacket(idMapTag, typeTag);
        }

        public void handle() {
            ImmutableMap dimTypeMap;
            DimIntIdMap rec = DimIntIdMap.fromTag(this.dimIntIdTag);
            LOGGER.info("Client received dim id sync packet\n{}", (Object)rec);
            DimensionIntId.clientRecord = rec;
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (String key : this.dimTypeTag.method_10541()) {
                class_5321 dimId = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)McHelper.newResourceLocation(key));
                String dimTypeId = this.dimTypeTag.method_10558(key);
                class_5321 dimType = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)McHelper.newResourceLocation(dimTypeId));
                builder.put((Object)dimId, (Object)dimType);
            }
            ClientWorldLoader.dimIdToDimTypeId = dimTypeMap = builder.build();
            LOGGER.info("Client accepted dimension type mapping {}", (Object)dimTypeMap);
        }

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }
    }
}

